

var _bver    = parseInt(navigator.appVersion);
var Nav4     = ((navigator.appName == "Netscape") && _bver==4);
var Nav5plus = ((navigator.appName == "Netscape") && _bver>4);
var IE4plus  = ((navigator.userAgent.indexOf("MSIE") != -1) && _bver>4);

// strings that need localization - don't localize anything not listed here
var L_BadNumber		= "This parameter is of type \"Number\" and can only contain a negative sign, digits (\"0-9\"), and a period decimal separator. Please correct the entered parameter value.";
var L_BadCurrency	= "This parameter is of type \"Currency\" and can only contain a negative sign, digits (\"0-9\"), and a period decimal separator. Please correct the entered parameter value.";
var L_BadDate		= "This parameter is of type \"Date\" and should be in the format \"Date(yyyy,mm,dd)\" where \"yyyy\" is the four digit year, \"mm\" is the month (e.g. January = 1), and \"dd\" is the number of days into the given month.";
var L_BadDateTime   = "This parameter is of type \"DateTime\" and the correct format is \"DateTime(yyyy,mm,dd,hh,mm,ss)\". \"yyyy\" is the four digit year, \"mm\" is the month (e.g. January = 1), \"dd\" is the day of the month, \"hh\" is hours in a 24 hour, \"mm\" is minutes and \"ss\" is seconds.";
var L_BadTime       = "This parameter is of type \"Time\" and should be in the format \"Time(hh,mm,ss)\" where \"hh\" is hours in 24 a hour clock, \"mm\" is minutes into the hour, and \"ss\" is seconds into the minute.";

//////////////////////////////
// FOR DEBUGGING ONLY
debug = false;
function dumpFormFields(formName)
{
    theForm = document.forms[formName];
    for ( idx = 0; idx < theForm.elements.length; ++idx )
        alert ( theForm.elements[idx].name + " - " + theForm.elements[idx].value );
}

///////////////////////////////
// properly escapes prompt values
function escapePrompt (prompt)
{
    if ( prompt != null && prompt != "" ) {
        prompt = prompt.replace (/\\/g, "\\\\"); // replace \ with \\ globally
        prompt = prompt.replace (/"/g, "\\\"");  // replace " with \" globally
    }
    return "\"" + prompt + "\"";
}

////////////////////////////////////
// generic "add" function which calls one of the two below. Note: won't work for range _and_ discrete prompts,
// only one or the other cases
function addPromptValue ( inForm, type )
{
    if ( inForm["DiscreteValue"] != null )
        return addPromptDiscreteValue ( inForm, type );
    else if ( inForm["LowerBound"] != null )
        return addPromptRangeValue ( inForm, type );
}
        
////////////////////////////////
// add number, currency, string from dropdown/textbox to list box
// where multiple prompt values are supported
function addPromptDiscreteValue ( inForm, type )
{
	var widget, obj;
    widget = obj = inForm.DiscreteValue;
	if ( obj.type && obj.type.toLowerCase() != "text" && obj.type.toLowerCase() != "password" )
	{
		//select box not a textbox
		obj = obj.options[obj.selectedIndex];
	}
	if ( ! checkSingleValue ( obj.value, type, inForm.name ) )
    {
        widget.focus();
		return false;
    }
	promptValue =  escapePrompt(obj.value);
	displayString = ( obj.text ) ? obj.text : obj.value;
	promptEntry = new Option(displayString,promptValue,false,false);
	theList = inForm.ListBox;
	theList.options[theList.length] = promptEntry;

    widget.focus ();
    if ( widget.select )
        widget.select ();
    if ( widget.type.toLowerCase != "text" && widget.type.toLowerCase != "password" )
        if ( widget.selectedIndex < widget.length - 1 )
            widget.selectedIndex = widget.selectedIndex + 1;      //... or move to next selection in listbox
    //if ( Nav4 )
    //      history.go(0);
}

////////////////////////////////////
// adds Range prompt to listbox where multiple values are supported
function addPromptRangeValue ( inForm, type )
{
    lowerBound = inForm.LowerBound;
    upperBound = inForm.UpperBound;
    //handle select box, not text box case
    if ( lowerBound.type.toLowerCase () != "text" &&
         lowerBound.type.toLowerCase () != "password" )  //either upper or lower, doesn't matter
    {
        lowerBound = lowerBound.options[lowerBound.selectedIndex];
        upperBound = upperBound.options[upperBound.selectedIndex];
    }
    
    lowerUnBounded = inForm.NoLowerBoundCheck.checked;
    upperUnBounded = inForm.NoUpperBoundCheck.checked;
    lvalue = uvalue = "";

    if ( ! lowerUnBounded )
    {
        if ( ! checkSingleValue ( lowerBound.value, type, inForm.name ) ) {
            if ( lowerBound.focus )
                lowerBound.focus ();
            return false;
        }
        lvalue = lowerBound.value;
    }
    if ( ! upperUnBounded )
    {
        if ( ! checkSingleValue ( upperBound.value, type, inForm.name ) ) {
            if ( upperBound.focus )
                upperBound.focus ();
            return false;
        }
        uvalue = upperBound.value;
    }
    ldisplay = (lowerBound.text && !lowerUnBounded) ? lowerBound.text : lvalue;
    udisplay = (upperBound.text && !upperUnBounded) ? upperBound.text : uvalue;
    
    lowerChecked = inForm.LowerCheck.checked;
    upperChecked = inForm.UpperCheck.checked;
    
    value = ( lowerChecked && ! lowerUnBounded ) ? "[" : "(";
    if ( ! lowerUnBounded ) //unbounded is empty string not quoted empty string (e.g not "\"\"")
        value += escapePrompt(lvalue);
    value += "-"
    if ( ! upperUnBounded )
        value += escapePrompt(uvalue);
    value += (upperChecked && ! upperUnBounded ) ? "]" : ")";
    if ( debug ) alert (value);

    display = ( lowerChecked && ! lowerUnBounded ) ? "[" : "(";
    display += ldisplay;
    display += "  ..  "
    display += udisplay;
    display += (upperChecked && ! upperUnBounded ) ? "]" : ")";

	promptEntry = new Option(display,value,false,false);
	theList = inForm.ListBox;
	theList.options[theList.length] = promptEntry;
    //if ( Nav4 )
    //      history.go(0);
}

////////////////////////////////////
// puts "select" value into text box for an editable prompt which also has defaults
function setSelectedValue (inForm, selectCtrl, textCtrl)
{
    selectedOption = inForm[selectCtrl].options[inForm[selectCtrl].selectedIndex];
    inForm[textCtrl].value = selectedOption.value;
	//if ( Nav4 )
	//      history.go(0);
}

///////////////////////////////////
// remove value from listbox where multiple value prompts are supported
function removeFromListBox ( inForm )
{
	lbox = inForm.ListBox;
	for ( var idx = 0; idx < lbox.options.length; )
	{
		if ( lbox.options[idx].selected )
			lbox.options[idx] = null;
		else
			idx++;
	}
	//if ( Nav4 )
	//      history.go(0);
}

/////////////////////////////////////
// sets prompt value into the hidden form field in proper format so that it can be submitted
function setPromptSingleValue (promptName,type)
{
    submitForm = document.forms.PromptSubmitter;
    promptForm = document.forms[promptName];
    hiddenField = submitForm.elements[promptName];
    value = "";
    if ( promptForm["NULL"] != null && promptForm["NULL"].checked )
        value = "NULL"; //NULL is a literal for, uhmm.. a NULL
    else
    {
        if ( promptForm.DiscreteValue.type.toLowerCase () != "text" &&
             promptForm.DiscreteValue.type.toLowerCase () != "password" )
            value = promptForm.DiscreteValue.options[promptForm.DiscreteValue.selectedIndex].value;
        else
            value = promptForm.DiscreteValue.value;
        if ( ! checkSingleValue ( value, type, promptName ) ) {
            promptForm.DiscreteValue.focus ();            
            return false;
        }
        else
            value = escapePrompt(value);
    }
    hiddenField.value = value;
	return true;
}

/////////////////////////////////////
// sets prompt value for a range into the hidden form field in proper format so that it can be submitted
function setPromptRangeValue (promptName,type)
{
    submitForm = document.forms.PromptSubmitter;
    promptForm = document.forms[promptName];
    hiddenField = submitForm.elements[promptName];

    lowerBound = promptForm.LowerBound;
    upperBound = promptForm.UpperBound;
    //handle select box, not text box case
    if ( lowerBound.type.toLowerCase () != "text" &&
         lowerBound.type.toLowerCase () != "password" )  //either upper or lower, doesn't matter
    {
        lowerBound = lowerBound.options[lowerBound.selectedIndex];
        upperBound = upperBound.options[upperBound.selectedIndex];
    }
    lowerUnBounded = promptForm.NoLowerBoundCheck.checked;
    upperUnBounded = promptForm.NoUpperBoundCheck.checked;
    lowerChecked = promptForm.LowerCheck.checked;
    upperChecked = promptForm.UpperCheck.checked;
    uvalue = lvalue = "";

    if ( ! lowerUnBounded )
    {
        if ( ! checkSingleValue ( lowerBound.value, type, promptName ) ) {
            if ( lowerBound.focus )
                lowerBound.focus();
            return false;
        }
        lvalue = lowerBound.value;
    }
    if ( ! upperUnBounded )
    {
        if ( ! checkSingleValue ( upperBound.value, type, promptName ) ) {
            if ( upperBound.focus )
                upperBound.focus ();
            return false;
        }
        uvalue = upperBound.value;
    }
    value = ( lowerChecked && ! lowerUnBounded ) ? "[" : "(";
    if ( ! lowerUnBounded )
        value += escapePrompt(lvalue);
    value += "-"
    if ( ! upperUnBounded )
        value += escapePrompt(uvalue);
    value += (upperChecked && ! upperUnBounded ) ? "]" : ")";
    if ( debug )
        alert (value);
    hiddenField.value = value;
	return true;
}

/////////////////////////////////////
// sets prompt value into the hidden form field in proper format so that it can be submitted
function setPromptMultipleValue (promptName)
{
    submitForm = document.forms.PromptSubmitter;
    promptForm = document.forms[promptName];
    hiddenField = submitForm.elements[promptName];
    values = promptForm.ListBox.options;
    value = "";
    for ( idx = 0; idx < values.length; ++idx )
    {
        if ( value.length != 0 )
            value += ","
        value += values[idx].value;
    }
    if ( value == "" )
        value = "\"\"";     //if value is empty, set to empty string
    if ( debug )
        alert (value);
    hiddenField.value = value;
    //NOTE: we'll always return true as the validation is done before values are added to select box
	return true;
}

///////////////////////////////////
// sets logon values (user and password) into the hidden form fields
function setLogonValue (logonName)
{
    submitForm = document.forms.PromptSubmitter;
    logonForm = document.forms[logonName];

    hiddenUserField = submitForm.elements["user-" + logonName];
    hiddenPassField = submitForm.elements["password-" + logonName];
    
    hiddenUserField.value = logonForm.User.value;
    hiddenPassField.value = logonForm.Password.value;
    if ( debug )
        alert ( "User:" + hiddenUserField.value + " - Password:" + hiddenUserField.password );
}

///////////////////////////////////////
// check and alert user about any errors based on type of prompt
var promptPrefix = "promptex-";
var regNumber    = /^-?((\d+)|(\d*\.\d+))$/
var regCurrency  = regNumber;
var regDate		 = /^(D|d)(A|a)(T|t)(E|e) *\( *\d{4} *, *(0?[1-9]|1[0-2]) *, *((0?[1-9]|[1-2]\d)|3(0|1)) *\)$/
var regDateTime  = /^(D|d)(A|a)(T|t)(E|e)(T|t)(I|i)(M|m)(E|e) *\( *\d{4} *, *(0?[1-9]|1[0-2]) *, *((0?[1-9]|[1-2]\d)|3(0|1)) *, *([0-1]?\d|2[0-3]) *, *[0-5]?\d *, *[0-5]?\d *\)$/
var regTime	     = /^(T|t)(I|i)(M|m)(E|e) *\( *([0-1]?\d|2[0-3]) *, *[0-5]?\d *, *[0-5]?\d *\)$/

function checkSingleValue ( value, type, promptName )
{
	if ( type == 'n' && ! regNumber.test ( value ) )
	{
		alert ( "\"" + promptName.substr(promptPrefix.length) + "\": " + L_BadNumber );
		return false;
	}
	else if ( type == 'd' && ! regDate.test ( value ) )
	{
		alert ( "\"" + promptName.substr(promptPrefix.length) + "\": " + L_BadDate );
		return false;
	}
	else if ( type == 'c' && ! regCurrency.test ( value ) )
	{
		alert ( "\"" + promptName.substr(promptPrefix.length) + "\": " + L_BadCurrency );
		return false;
	}
	else if ( type == "dt" && ! regDateTime.test ( value ) )
	{
		alert ( "\"" + promptName.substr(promptPrefix.length) + "\": " + L_BadDateTime );
		return false;
	}
	else if ( type == 't' && ! regTime.test ( value ) )
	{
		alert ( "\"" + promptName.substr(promptPrefix.length) + "\": " + L_BadTime );
		return false;
	}
	//by default let it go...
	return true;
}
